//  Copyright 2019 mobileknowledge. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "NTAG5_NFC_LIB.h"
#import "ISO15693Command.h"
#import "RFCommands.h"
#import "NSData+FastHex.h"
#import "Utils.h"
#import <math.h>

NS_ASSUME_NONNULL_BEGIN

@interface PassthroughUseCase: NSObject

+ (PassthroughUseCase *) sharedInstance;

/*!
 *@abstract   Initializes data to be written to the SRAM for the demo to be printed on the RF --> I2C mode log window
 **/
- (void)InitializeSRAMData:(void (^)(NSData *aData, NSString * text))success  onFailure : (void(^)(NSError *error))failure;

/*!
 *@abstract   Performs a continuous loop reading and writing to the SRAM depending on the tag Status command read in each iteration. A full loop involves 10 iterations.
 **/
- (void)SRAMLoop:(void (^)(NSData *aData, bool * isWrite ))success  onFailure : (void(^)(NSError *error))failure;

@end

NS_ASSUME_NONNULL_END
